/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.internal.scripting.Messages;
import com.aptana.editor.common.internal.scripting.NewFileWizard;
import com.aptana.editor.common.internal.scripting.WizardNewFilePage;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TemplateSelectionPage
extends WizardPage
implements ISelectionChangedListener {
    private static String TEMPLATE_IMAGE_PATH = "icons/template.png";
    private TemplateElement[] templates;
    private Button useTemplateBt;
    private Text templatePreview;
    private ScrolledComposite scroll;
    private TableViewer templateSelectionViewer;

    public TemplateSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TemplateSelectionPage_title);
        this.setDescription(Messages.TemplateSelectionPage_description);
        this.templates = new TemplateElement[0];
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(10, 10).create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createAbove(container, 1);
        Label label = new Label(container, 0);
        label.setText(Messages.TemplateSelectionPage_available_templates);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 512);
        gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        this.templateSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        this.templateSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.templateSelectionViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.createPreview((Composite)sashForm);
        this.initializeViewer();
        this.templateSelectionViewer.setInput((Object)this.templates);
        this.templateSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            this.setPreviewContent((TemplateElement)selection.getFirstElement());
        } else {
            this.setPreviewContent(null);
        }
    }

    public TemplateElement getSelectedTemplate() {
        if (this.useTemplateBt.getSelection()) {
            ISelection selection = this.templateSelectionViewer.getSelection();
            if (selection != null) {
                TemplateElement selected = (TemplateElement)((StructuredSelection)selection).getFirstElement();
                if (selected != null) {
                    return selected;
                }
                this.loadTemplates();
                return this.templates != null && this.templates.length > 0 ? this.templates[0] : null;
            }
            if (this.templates != null && this.templates.length > 0) {
                return this.templates[0];
            }
        }
        return null;
    }

    protected void initializeViewer() {
        this.selectInitialTemplate();
    }

    protected void selectInitialTemplate() {
        if (this.templates.length > 0) {
            this.templateSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.templates[0]), true);
            this.setPreviewContent(this.templates[0]);
        }
    }

    protected void createPreview(Composite composite) {
        this.scroll = new ScrolledComposite(composite, 2816);
        this.scroll.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.scroll.setLayoutData((Object)gd);
        this.templatePreview = new Text((Composite)this.scroll, 10);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.scroll.setContent((Control)this.templatePreview);
    }

    protected void setPreviewContent(TemplateElement template) {
        WizardNewFileCreationPage fileCreationPage = (WizardNewFileCreationPage)this.getPreviousPage();
        String templateContent = null;
        try {
            IPath path = fileCreationPage.getContainerFullPath().append(fileCreationPage.getFileName());
            templateContent = NewFileWizard.getTemplateContent(template, path);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        if (templateContent == null) {
            this.templatePreview.setText("");
        } else {
            this.templatePreview.setText(templateContent);
        }
        this.scroll.setMinSize(this.templatePreview.computeSize(-1, -1));
    }

    protected void createAbove(Composite container, int span) {
        this.useTemplateBt = new Button(container, 32);
        this.useTemplateBt.setText(Messages.TemplateSelectionPage_use_templates_button_text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.useTemplateBt.setLayoutData((Object)gd);
        this.useTemplateBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateSelectionPage.this.updatePageControls();
            }
        });
        this.useTemplateBt.setSelection(true);
    }

    private void loadTemplates() {
        WizardNewFilePage page = (WizardNewFilePage)this.getWizard().getPage("mainPage");
        this.templates = page.getTemplates();
        this.updatePageControls();
    }

    private void updatePageControls() {
        boolean componentsEnabled = this.useTemplateBt.getSelection();
        this.templateSelectionViewer.getControl().setEnabled(componentsEnabled);
        this.templatePreview.setEnabled(componentsEnabled);
        this.setMessage(null);
        if (componentsEnabled) {
            this.setDescription(Messages.TemplateSelectionPage_description);
        } else {
            this.setDescription("");
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.loadTemplates();
            this.templateSelectionViewer.setInput((Object)this.templates);
            this.selectInitialTemplate();
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        WizardNewFilePage page = (WizardNewFilePage)this.getWizard().getPage("mainPage");
        this.templates = page.getTemplates();
        if (this.templates == null) {
            return true;
        }
        if (this.templates.length < 2) {
            return true;
        }
        if (!this.useTemplateBt.getSelection()) {
            return true;
        }
        ISelection selection = this.templateSelectionViewer.getSelection();
        if (selection == null) {
            return false;
        }
        TemplateElement selected = (TemplateElement)((StructuredSelection)selection).getFirstElement();
        return selected != null;
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TemplateSelectionPage.this.templates;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            TemplateElement section = (TemplateElement)obj;
            if (index == 0) {
                return section.getDisplayName();
            }
            return section.getFiletype();
        }

        public Image getColumnImage(Object obj, int index) {
            return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)TEMPLATE_IMAGE_PATH);
        }
    }
}

